import { map } from './map';
import { from } from '../observable/from';
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function mergeMap(project, resultSelector, concurrent = Infinity) {
    if (typeof resultSelector === 'function') {
        return (source) => source.pipe(mergeMap((a, i) => from(project(a, i)).pipe(map((b, ii) => resultSelector(a, b, i, ii))), concurrent));
    }
    else if (typeof resultSelector === 'number') {
        concurrent = resultSelector;
    }
    return operate((source, subscriber) => {
        let isComplete = false;
        let active = 0;
        let index = 0;
        let buffer = [];
        const checkComplete = () => isComplete && !active && subscriber.complete();
        const tryInnerSub = () => {
            while (active < concurrent && buffer.length > 0) {
                doInnerSub(buffer.shift());
            }
        };
        const doInnerSub = (value) => {
            active++;
            subscriber.add(from(project(value, index++)).subscribe(new OperatorSubscriber(subscriber, (innerValue) => subscriber.next(innerValue), undefined, () => {
                active--;
                buffer.length && tryInnerSub();
                checkComplete();
            })));
        };
        let outerSubs;
        outerSubs = source.subscribe(new OperatorSubscriber(subscriber, (value) => (active < concurrent ? doInnerSub(value) : buffer.push(value)), undefined, () => {
            isComplete = true;
            checkComplete();
            outerSubs === null || outerSubs === void 0 ? void 0 : outerSubs.unsubscribe();
        }));
        return () => {
            buffer = null;
        };
    });
}
export const flatMap = mergeMap;
//# sourceMappingURL=mergeMap.js.map