import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { from } from '../observable/from';
export function mergeScan(accumulator, seed, concurrent = Infinity) {
    return operate((source, subscriber) => {
        let buffer = [];
        let active = 0;
        let hasState = false;
        let state = seed;
        let index = 0;
        let isComplete = false;
        const checkComplete = () => {
            if (isComplete && !buffer.length && !active) {
                !hasState && subscriber.next(state);
                subscriber.complete();
            }
        };
        const doInnerSub = (value) => {
            active++;
            from(accumulator(state, value, index++)).subscribe(new OperatorSubscriber(subscriber, (innerValue) => {
                hasState = true;
                subscriber.next((state = innerValue));
            }, undefined, () => {
                active--;
                buffer.length && tryInnerSub();
                checkComplete();
            }));
        };
        const tryInnerSub = () => {
            while (buffer.length && active < concurrent) {
                doInnerSub(buffer.shift());
            }
        };
        source.subscribe(new OperatorSubscriber(subscriber, (value) => (active < concurrent ? doInnerSub(value) : buffer.push(value)), undefined, () => {
            isComplete = true;
            checkComplete();
        }));
        return () => {
            buffer = null;
        };
    });
}
//# sourceMappingURL=mergeScan.js.map