import { operate } from '../util/lift';
import { isScheduler } from '../util/isScheduler';
import { argsOrArgArray } from '../util/argsOrArgArray';
import { fromArray } from '../observable/fromArray';
import { mergeAll } from './mergeAll';
export function merge(...args) {
    let concurrent = Infinity;
    let scheduler = undefined;
    if (isScheduler(args[args.length - 1])) {
        scheduler = args.pop();
    }
    if (typeof args[args.length - 1] === 'number') {
        concurrent = args.pop();
    }
    args = argsOrArgArray(args);
    return operate((source, subscriber) => {
        mergeAll(concurrent)(fromArray([source, ...args], scheduler)).subscribe(subscriber);
    });
}
export function mergeWith(...otherSources) {
    return merge(...otherSources);
}
//# sourceMappingURL=mergeWith.js.map