import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function sample(notifier) {
    return operate((source, subscriber) => {
        let hasValue = false;
        let lastValue = null;
        source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            hasValue = true;
            lastValue = value;
        }));
        const emit = () => {
            if (hasValue) {
                hasValue = false;
                const value = lastValue;
                lastValue = null;
                subscriber.next(value);
            }
        };
        notifier.subscribe(new OperatorSubscriber(subscriber, emit, undefined, emit));
    });
}
//# sourceMappingURL=sample.js.map