import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function scan(accumulator, seed) {
    const hasSeed = arguments.length >= 2;
    return operate((source, subscriber) => {
        let hasState = hasSeed;
        let state = seed;
        let index = 0;
        source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            const i = index++;
            subscriber.next((state = hasState
                ?
                    accumulator(state, value, i)
                :
                    ((hasState = true), value)));
        }));
    });
}
//# sourceMappingURL=scan.js.map