import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { from } from '../observable/from';
import { noop } from '../util/noop';
export function skipUntil(notifier) {
    return operate((source, subscriber) => {
        let taking = false;
        const skipSubscriber = new OperatorSubscriber(subscriber, () => {
            skipSubscriber === null || skipSubscriber === void 0 ? void 0 : skipSubscriber.unsubscribe();
            taking = true;
        }, undefined, noop);
        from(notifier).subscribe(skipSubscriber);
        source.subscribe(new OperatorSubscriber(subscriber, (value) => taking && subscriber.next(value)));
    });
}
//# sourceMappingURL=skipUntil.js.map