import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { from } from '../observable/from';
export const defaultThrottleConfig = {
    leading: true,
    trailing: false,
};
export function throttle(durationSelector, { leading, trailing } = defaultThrottleConfig) {
    return operate((source, subscriber) => {
        let hasValue = false;
        let sendValue = null;
        let throttled = null;
        const throttlingDone = () => {
            throttled === null || throttled === void 0 ? void 0 : throttled.unsubscribe();
            throttled = null;
            trailing && send();
        };
        const throttle = (value) => (throttled = from(durationSelector(value)).subscribe(new OperatorSubscriber(subscriber, throttlingDone, undefined, throttlingDone)));
        const send = () => {
            if (hasValue) {
                subscriber.next(sendValue);
                throttle(sendValue);
            }
            hasValue = false;
            sendValue = null;
        };
        source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            hasValue = true;
            sendValue = value;
            !throttled && (leading ? send() : throttle(value));
        }));
    });
}
//# sourceMappingURL=throttle.js.map