import { asyncScheduler } from '../scheduler/async';
import { defaultThrottleConfig } from './throttle';
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function throttleTime(duration, scheduler = asyncScheduler, { leading = false, trailing = false } = defaultThrottleConfig) {
    return operate((source, subscriber) => {
        let hasTrailingValue = false;
        let trailingValue = null;
        let throttleSubs = null;
        let isComplete = false;
        const throttleJob = () => {
            throttleSubs = null;
            if (trailing && hasTrailingValue) {
                hasTrailingValue = false;
                emit(trailingValue);
                trailingValue = null;
            }
            if (isComplete) {
                subscriber.complete();
            }
        };
        const startThrottle = () => subscriber.add((throttleSubs = scheduler.schedule(throttleJob, duration)));
        const setTrailing = (value) => {
            if (trailing) {
                hasTrailingValue = true;
                trailingValue = value;
            }
        };
        const emit = (value) => {
            subscriber.next(value);
            !isComplete && startThrottle();
        };
        source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            if (throttleSubs) {
                setTrailing(value);
            }
            else {
                if (leading) {
                    emit(value);
                }
                else {
                    setTrailing(value);
                    startThrottle();
                }
            }
        }, undefined, () => {
            isComplete = true;
            (!trailing || !throttleSubs || !hasTrailingValue) && subscriber.complete();
        }));
    });
}
//# sourceMappingURL=throttleTime.js.map