import { asyncScheduler } from '../scheduler/async';
import { isValidDate } from '../util/isDate';
import { operate } from '../util/lift';
import { from } from '../observable/from';
import { createErrorClass } from '../util/createErrorClass';
import { OperatorSubscriber } from './OperatorSubscriber';
export const TimeoutError = createErrorClass((_super) => function TimeoutError(info = null) {
    _super(this);
    this.message = 'Timeout has occurred';
    this.name = 'TimeoutError';
    this.info = info;
});
export function timeout(config, schedulerArg) {
    const { first, each, with: _with = timeoutErrorFactory, scheduler = schedulerArg !== null && schedulerArg !== void 0 ? schedulerArg : asyncScheduler, meta = null } = (isValidDate(config)
        ? { first: config }
        : typeof config === 'number'
            ? { each: config }
            : config);
    if (first == null && each == null) {
        throw new TypeError('No timeout provided.');
    }
    return operate((source, subscriber) => {
        let originalSourceSubscription;
        let timerSubscription;
        let lastValue = null;
        let seen = 0;
        const startTimer = (delay) => {
            subscriber.add((timerSubscription = scheduler.schedule(() => {
                let withObservable;
                try {
                    withObservable = from(_with({
                        meta,
                        lastValue,
                        seen,
                    }));
                }
                catch (err) {
                    subscriber.error(err);
                    return;
                }
                originalSourceSubscription.unsubscribe();
                withObservable.subscribe(subscriber);
            }, delay)));
        };
        subscriber.add((originalSourceSubscription = source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            timerSubscription.unsubscribe();
            seen++;
            subscriber.next((lastValue = value));
            each > 0 && startTimer(each);
        }, undefined, undefined, () => {
            lastValue = null;
        }))));
        startTimer(first != null ? (typeof first === 'number' ? first : +first - scheduler.now()) : each);
    });
}
function timeoutErrorFactory(info) {
    throw new TimeoutError(info);
}
//# sourceMappingURL=timeout.js.map