import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { from } from '../observable/from';
import { identity } from '../util/identity';
import { noop } from '../util/noop';
export function withLatestFrom(...inputs) {
    let project;
    if (typeof inputs[inputs.length - 1] === 'function') {
        project = inputs.pop();
    }
    return operate((source, subscriber) => {
        const len = inputs.length;
        const otherValues = new Array(len);
        let hasValue = inputs.map(() => false);
        let ready = false;
        source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            if (ready) {
                const values = [value, ...otherValues];
                subscriber.next(project ? project(...values) : values);
            }
        }));
        for (let i = 0; i < len; i++) {
            const input = inputs[i];
            let otherSource;
            try {
                otherSource = from(input);
            }
            catch (err) {
                subscriber.error(err);
                return;
            }
            otherSource.subscribe(new OperatorSubscriber(subscriber, (value) => {
                otherValues[i] = value;
                if (!ready && !hasValue[i]) {
                    hasValue[i] = true;
                    (ready = hasValue.every(identity)) && (hasValue = null);
                }
            }, undefined, noop));
        }
    });
}
//# sourceMappingURL=withLatestFrom.js.map