import { operate } from '../util/lift';
import { zip } from '../observable/zip';
export function zipAll(project) {
    return operate((source, subscriber) => {
        const sources = [];
        subscriber.add(source.subscribe({
            next: (source) => sources.push(source),
            error: (err) => subscriber.error(err),
            complete: () => {
                if (sources.length > 0) {
                    const args = project ? [...sources, project] : sources;
                    subscriber.add(zip(...args).subscribe(subscriber));
                }
                else {
                    subscriber.complete();
                }
            },
        }));
    });
}
//# sourceMappingURL=zipAll.js.map