import { createErrorClass } from './createErrorClass';
export const UnsubscriptionError = createErrorClass((_super) => function UnsubscriptionError(errors) {
    _super(this);
    this.message = errors
        ? `${errors.length} errors occurred during unsubscription:
${errors.map((err, i) => `${i + 1}) ${err.toString()}`).join('\n  ')}`
        : '';
    this.name = 'UnsubscriptionError';
    this.errors = errors;
});
//# sourceMappingURL=UnsubscriptionError.js.map