import { reportUnhandledError } from './reportUnhandledError';
export const subscribeToPromise = (promise) => (subscriber) => {
    promise.then((value) => {
        if (!subscriber.closed) {
            subscriber.next(value);
            subscriber.complete();
        }
    }, (err) => subscriber.error(err))
        .then(null, reportUnhandledError);
    return subscriber;
};
//# sourceMappingURL=subscribeToPromise.js.map