import { __spreadArrays } from "tslib";
import { Observable } from '../Observable';
import { isScheduler } from '../util/isScheduler';
import { mapOneOrManyArgs } from '../util/mapOneOrManyArgs';
export function bindCallback(callbackFunc, resultSelector, scheduler) {
    if (resultSelector) {
        if (isScheduler(resultSelector)) {
            scheduler = resultSelector;
        }
        else {
            return function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return bindCallback(callbackFunc, scheduler).apply(void 0, args).pipe(mapOneOrManyArgs(resultSelector));
            };
        }
    }
    return function () {
        var _this = this;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var results;
        var hasResults = false;
        var hasError = false;
        var error;
        return new Observable(function (subscriber) {
            if (!scheduler) {
                var isCurrentlyAsync_1 = false;
                var hasCompletedSynchronously_1 = false;
                if (hasResults) {
                    subscriber.next(results);
                    subscriber.complete();
                }
                else if (hasError) {
                    subscriber.error(error);
                }
                else {
                    var handler = function () {
                        var innerArgs = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            innerArgs[_i] = arguments[_i];
                        }
                        hasResults = true;
                        results = innerArgs.length <= 1 ? innerArgs[0] : innerArgs;
                        subscriber.next(results);
                        if (isCurrentlyAsync_1) {
                            subscriber.complete();
                        }
                        else {
                            hasCompletedSynchronously_1 = true;
                        }
                    };
                    try {
                        callbackFunc.apply(_this, __spreadArrays(args, [handler]));
                    }
                    catch (err) {
                        hasError = true;
                        error = err;
                        subscriber.error(err);
                    }
                    isCurrentlyAsync_1 = true;
                    if (hasCompletedSynchronously_1 && !hasError) {
                        subscriber.complete();
                    }
                }
                return;
            }
            else {
                var scheduleNext_1 = function (value) {
                    hasResults = true;
                    results = value.length <= 1 ? value[0] : value;
                    subscriber.add(scheduler.schedule(function () {
                        subscriber.next(results);
                        subscriber.add(scheduler.schedule(function () {
                            subscriber.complete();
                        }));
                    }));
                };
                var scheduleError_1 = function (err) {
                    hasError = true;
                    error = err;
                    subscriber.add(scheduler.schedule(function () {
                        subscriber.error(error);
                    }));
                };
                return scheduler.schedule(function () {
                    if (hasResults) {
                        scheduleNext_1(results);
                    }
                    else if (hasError) {
                        scheduleError_1(error);
                    }
                    else {
                        try {
                            callbackFunc.apply(_this, __spreadArrays(args, [
                                function () {
                                    var innerArgs = [];
                                    for (var _i = 0; _i < arguments.length; _i++) {
                                        innerArgs[_i] = arguments[_i];
                                    }
                                    return scheduleNext_1(innerArgs);
                                }
                            ]));
                        }
                        catch (err) {
                            scheduleError_1(err);
                            return;
                        }
                    }
                });
            }
        });
    };
}
//# sourceMappingURL=bindCallback.js.map