import { Observable } from '../Observable';
import { from } from './from';
export function defer(observableFactory) {
    return new Observable(function (subscriber) {
        var input;
        try {
            input = observableFactory();
        }
        catch (err) {
            subscriber.error(err);
            return undefined;
        }
        var source = from(input);
        return source.subscribe(subscriber);
    });
}
//# sourceMappingURL=defer.js.map