import { subscribeToArray } from '../util/subscribeToArray';
import { subscribeToPromise } from '../util/subscribeToPromise';
import { subscribeToIterable } from '../util/subscribeToIterable';
import { subscribeToObservable } from '../util/subscribeToObservable';
import { isArrayLike } from '../util/isArrayLike';
import { isPromise } from '../util/isPromise';
import { isObject } from '../util/isObject';
import { iterator as Symbol_iterator } from '../symbol/iterator';
import { observable as Symbol_observable } from '../symbol/observable';
import { subscribeToAsyncIterable } from '../util/subscribeToAsyncIterable';
import { Observable } from '../Observable';
import { scheduled } from '../scheduled/scheduled';
export function from(input, scheduler) {
    if (!scheduler) {
        if (input instanceof Observable) {
            return input;
        }
        return new Observable(subscribeTo(input));
    }
    else {
        return scheduled(input, scheduler);
    }
}
function subscribeTo(result) {
    if (result && typeof result[Symbol_observable] === 'function') {
        return subscribeToObservable(result);
    }
    else if (isArrayLike(result)) {
        return subscribeToArray(result);
    }
    else if (isPromise(result)) {
        return subscribeToPromise(result);
    }
    else if (result && typeof result[Symbol_iterator] === 'function') {
        return subscribeToIterable(result);
    }
    else if (Symbol && Symbol.asyncIterator &&
        !!result && typeof result[Symbol.asyncIterator] === 'function') {
        return subscribeToAsyncIterable(result);
    }
    else {
        var value = isObject(result) ? 'an invalid object' : "'" + result + "'";
        var msg = "You provided " + value + " where a stream was expected."
            + ' You can provide an Observable, Promise, Array, AsyncIterable, or Iterable.';
        throw new TypeError(msg);
    }
}
;
//# sourceMappingURL=from.js.map