import { Observable } from '../Observable';
import { identity } from '../util/identity';
import { isScheduler } from '../util/isScheduler';
export function generate(initialStateOrOptions, condition, iterate, resultSelectorOrScheduler, scheduler) {
    var resultSelector;
    var initialState;
    if (arguments.length == 1) {
        var options = initialStateOrOptions;
        initialState = options.initialState;
        condition = options.condition;
        iterate = options.iterate;
        resultSelector = options.resultSelector || identity;
        scheduler = options.scheduler;
    }
    else {
        initialState = initialStateOrOptions;
        if (!resultSelectorOrScheduler || isScheduler(resultSelectorOrScheduler)) {
            resultSelector = identity;
            scheduler = resultSelectorOrScheduler;
        }
        else {
            resultSelector = resultSelectorOrScheduler;
        }
    }
    return new Observable(function (subscriber) {
        var state = initialState;
        if (scheduler) {
            var needIterate_1 = false;
            return scheduler.schedule(function () {
                if (!subscriber.closed) {
                    try {
                        needIterate_1 ? (state = iterate(state)) : (needIterate_1 = true);
                        condition && !condition(state) ? subscriber.complete() : subscriber.next(resultSelector(state));
                    }
                    catch (err) {
                        subscriber.error(err);
                    }
                    if (!subscriber.closed) {
                        this.schedule(state);
                    }
                }
            });
        }
        try {
            do {
                if (condition && !condition(state)) {
                    subscriber.complete();
                }
                else {
                    subscriber.next(resultSelector(state));
                    !subscriber.closed && (state = iterate(state));
                }
            } while (!subscriber.closed);
        }
        catch (err) {
            subscriber.error(err);
        }
        return undefined;
    });
}
//# sourceMappingURL=generate.js.map