import { Observable } from '../Observable';
export function throwError(errorOrErrorFactory, scheduler) {
    if (!scheduler) {
        return new Observable(function (subscriber) {
            return subscriber.error(typeof errorOrErrorFactory === 'function' ? errorOrErrorFactory() : errorOrErrorFactory);
        });
    }
    else {
        return new Observable(function (subscriber) {
            return scheduler.schedule(function () {
                subscriber.error(typeof errorOrErrorFactory === 'function' ? errorOrErrorFactory() : errorOrErrorFactory);
            });
        });
    }
}
//# sourceMappingURL=throwError.js.map