import { Observable } from '../Observable';
import { async as asyncScheduler } from '../scheduler/async';
import { isScheduler } from '../util/isScheduler';
import { isValidDate } from '../util/isDate';
export function timer(dueTime, periodOrScheduler, scheduler) {
    if (dueTime === void 0) { dueTime = 0; }
    var period = -1;
    if (periodOrScheduler != null) {
        if (isScheduler(periodOrScheduler)) {
            scheduler = periodOrScheduler;
        }
        else {
            period = periodOrScheduler;
        }
    }
    if (!isScheduler(scheduler)) {
        scheduler = asyncScheduler;
    }
    return new Observable(function (subscriber) {
        var due = Math.max(0, isValidDate(dueTime) ? +dueTime - scheduler.now() : dueTime);
        return scheduler.schedule(dispatch, due, {
            counter: 0,
            period: period,
            subscriber: subscriber,
        });
    });
}
function dispatch(state) {
    var period = state.period, subscriber = state.subscriber;
    var counter = state.counter++;
    subscriber.next(counter);
    if (!subscriber.closed) {
        if (period < 0) {
            return subscriber.complete();
        }
        this.schedule(state, period);
    }
}
//# sourceMappingURL=timer.js.map