import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function buffer(closingNotifier) {
    return operate(function (source, subscriber) {
        var buffer = [];
        source.subscribe(new OperatorSubscriber(subscriber, function (value) { return buffer.push(value); }));
        closingNotifier.subscribe(new OperatorSubscriber(subscriber, function () {
            var b = buffer;
            buffer = [];
            subscriber.next(b);
        }));
        return function () {
            buffer = null;
        };
    });
}
//# sourceMappingURL=buffer.js.map