import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { arrRemove } from '../util/arrRemove';
export function bufferCount(bufferSize, startBufferEvery) {
    if (startBufferEvery === void 0) { startBufferEvery = null; }
    startBufferEvery = startBufferEvery !== null && startBufferEvery !== void 0 ? startBufferEvery : bufferSize;
    return operate(function (source, subscriber) {
        var buffers = [];
        var count = 0;
        source.subscribe(new OperatorSubscriber(subscriber, function (value) {
            var toEmit = null;
            if (count++ % startBufferEvery === 0) {
                buffers.push([]);
            }
            for (var _i = 0, buffers_1 = buffers; _i < buffers_1.length; _i++) {
                var buffer = buffers_1[_i];
                buffer.push(value);
                if (bufferSize <= buffer.length) {
                    toEmit = toEmit !== null && toEmit !== void 0 ? toEmit : [];
                    toEmit.push(buffer);
                }
            }
            if (toEmit) {
                for (var _a = 0, toEmit_1 = toEmit; _a < toEmit_1.length; _a++) {
                    var buffer = toEmit_1[_a];
                    arrRemove(buffers, buffer);
                    subscriber.next(buffer);
                }
            }
        }, undefined, function () {
            for (var _i = 0, buffers_2 = buffers; _i < buffers_2.length; _i++) {
                var buffer = buffers_2[_i];
                subscriber.next(buffer);
            }
            subscriber.complete();
        }, function () {
            buffers = null;
        }));
    });
}
//# sourceMappingURL=bufferCount.js.map