import { __spreadArrays } from "tslib";
import { combineLatestInit } from '../observable/combineLatest';
import { operate } from '../util/lift';
import { argsOrArgArray } from '../util/argsOrArgArray';
import { mapOneOrManyArgs } from '../util/mapOneOrManyArgs';
import { pipe } from '../util/pipe';
export function combineLatest() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var project = undefined;
    if (typeof args[args.length - 1] === 'function') {
        project = args.pop();
        return pipe(combineLatest.apply(void 0, args), mapOneOrManyArgs(project));
    }
    return operate(function (source, subscriber) {
        return combineLatestInit(__spreadArrays([source], argsOrArgArray(args)))(subscriber);
    });
}
export function combineLatestWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return combineLatest.apply(void 0, otherSources);
}
//# sourceMappingURL=combineLatestWith.js.map