import { __spreadArrays } from "tslib";
import { operate } from '../util/lift';
import { concatAll } from './concatAll';
import { fromArray } from '../observable/fromArray';
import { isScheduler } from '../util/isScheduler';
export function concatWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return concat.apply(void 0, otherSources);
}
export function concat() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var scheduler;
    if (isScheduler(args[args.length - 1])) {
        scheduler = args.pop();
    }
    return operate(function (source, subscriber) {
        concatAll()(fromArray(__spreadArrays([source], args), scheduler)).subscribe(subscriber);
    });
}
//# sourceMappingURL=concatWith.js.map