import { asyncScheduler } from '../scheduler/async';
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function debounceTime(dueTime, scheduler) {
    if (scheduler === void 0) { scheduler = asyncScheduler; }
    return operate(function (source, subscriber) {
        var hasValue = false;
        var lastValue = null;
        var debounceSubscription = null;
        var emitLastValue = function () {
            hasValue = false;
            var value = lastValue;
            lastValue = null;
            subscriber.next(value);
        };
        source.subscribe(new OperatorSubscriber(subscriber, function (value) {
            debounceSubscription === null || debounceSubscription === void 0 ? void 0 : debounceSubscription.unsubscribe();
            hasValue = true;
            lastValue = value;
            subscriber.add((debounceSubscription = scheduler.schedule(function () {
                debounceSubscription = null;
                emitLastValue();
            }, dueTime)));
        }, undefined, function () {
            hasValue && emitLastValue();
            subscriber.complete();
        }));
    });
}
//# sourceMappingURL=debounceTime.js.map