import { asyncScheduler } from '../scheduler/async';
import { isValidDate } from '../util/isDate';
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function delay(delay, scheduler) {
    if (scheduler === void 0) { scheduler = asyncScheduler; }
    return operate(function (source, subscriber) {
        var isAbsoluteDelay = isValidDate(delay);
        var isComplete = false;
        var active = 0;
        var absoluteTimeValues = isAbsoluteDelay ? [] : null;
        var checkComplete = function () { return isComplete && !active && !(absoluteTimeValues === null || absoluteTimeValues === void 0 ? void 0 : absoluteTimeValues.length) && subscriber.complete(); };
        if (isAbsoluteDelay) {
            active++;
            subscriber.add(scheduler.schedule(function () {
                active--;
                if (absoluteTimeValues) {
                    var values = absoluteTimeValues;
                    absoluteTimeValues = null;
                    for (var _i = 0, values_1 = values; _i < values_1.length; _i++) {
                        var value = values_1[_i];
                        subscriber.next(value);
                    }
                }
                checkComplete();
            }, +delay - scheduler.now()));
        }
        source.subscribe(new OperatorSubscriber(subscriber, function (value) {
            if (isAbsoluteDelay) {
                absoluteTimeValues ? absoluteTimeValues.push(value) : subscriber.next(value);
            }
            else {
                active++;
                subscriber.add(scheduler.schedule(function () {
                    active--;
                    subscriber.next(value);
                    checkComplete();
                }, delay));
            }
        }, undefined, function () {
            isComplete = true;
            checkComplete();
        }));
        return function () {
            absoluteTimeValues = null;
        };
    });
}
//# sourceMappingURL=delay.js.map