import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { concat } from '../observable/concat';
import { take } from './take';
import { ignoreElements } from './ignoreElements';
export function delayWhen(delayDurationSelector, subscriptionDelay) {
    if (subscriptionDelay) {
        return function (source) {
            return concat(subscriptionDelay.pipe(take(1), ignoreElements()), source.pipe(delayWhen(delayDurationSelector)));
        };
    }
    return operate(function (source, subscriber) {
        var index = 0;
        var isComplete = false;
        var active = 0;
        var checkComplete = function () { return isComplete && !active && subscriber.complete(); };
        source.subscribe(new OperatorSubscriber(subscriber, function (value) {
            var closed = false;
            var notify = function () {
                subscriber.next(value);
                durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
                if (!closed) {
                    active--;
                    closed = true;
                    checkComplete();
                }
            };
            var durationSubscriber = new OperatorSubscriber(subscriber, notify, undefined, notify);
            active++;
            delayDurationSelector(value, index++).subscribe(durationSubscriber);
        }, undefined, function () {
            isComplete = true;
            checkComplete();
        }));
    });
}
//# sourceMappingURL=delayWhen.js.map