import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function every(predicate, thisArg) {
    return operate(function (source, subscriber) {
        var index = 0;
        source.subscribe(new OperatorSubscriber(subscriber, function (value) {
            if (!predicate.call(thisArg, value, index, source)) {
                subscriber.next(false);
                subscriber.complete();
            }
        }, undefined, function () {
            subscriber.next(true);
            subscriber.complete();
        }));
    });
}
//# sourceMappingURL=every.js.map