import { map } from './map';
import { from } from '../observable/from';
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function mergeMap(project, resultSelector, concurrent) {
    if (concurrent === void 0) { concurrent = Infinity; }
    if (typeof resultSelector === 'function') {
        return function (source) {
            return source.pipe(mergeMap(function (a, i) { return from(project(a, i)).pipe(map(function (b, ii) { return resultSelector(a, b, i, ii); })); }, concurrent));
        };
    }
    else if (typeof resultSelector === 'number') {
        concurrent = resultSelector;
    }
    return operate(function (source, subscriber) {
        var isComplete = false;
        var active = 0;
        var index = 0;
        var buffer = [];
        var checkComplete = function () { return isComplete && !active && subscriber.complete(); };
        var tryInnerSub = function () {
            while (active < concurrent && buffer.length > 0) {
                doInnerSub(buffer.shift());
            }
        };
        var doInnerSub = function (value) {
            active++;
            subscriber.add(from(project(value, index++)).subscribe(new OperatorSubscriber(subscriber, function (innerValue) { return subscriber.next(innerValue); }, undefined, function () {
                active--;
                buffer.length && tryInnerSub();
                checkComplete();
            })));
        };
        var outerSubs;
        outerSubs = source.subscribe(new OperatorSubscriber(subscriber, function (value) { return (active < concurrent ? doInnerSub(value) : buffer.push(value)); }, undefined, function () {
            isComplete = true;
            checkComplete();
            outerSubs === null || outerSubs === void 0 ? void 0 : outerSubs.unsubscribe();
        }));
        return function () {
            buffer = null;
        };
    });
}
export var flatMap = mergeMap;
//# sourceMappingURL=mergeMap.js.map