import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { from } from '../observable/from';
export function mergeScan(accumulator, seed, concurrent) {
    if (concurrent === void 0) { concurrent = Infinity; }
    return operate(function (source, subscriber) {
        var buffer = [];
        var active = 0;
        var hasState = false;
        var state = seed;
        var index = 0;
        var isComplete = false;
        var checkComplete = function () {
            if (isComplete && !buffer.length && !active) {
                !hasState && subscriber.next(state);
                subscriber.complete();
            }
        };
        var doInnerSub = function (value) {
            active++;
            from(accumulator(state, value, index++)).subscribe(new OperatorSubscriber(subscriber, function (innerValue) {
                hasState = true;
                subscriber.next((state = innerValue));
            }, undefined, function () {
                active--;
                buffer.length && tryInnerSub();
                checkComplete();
            }));
        };
        var tryInnerSub = function () {
            while (buffer.length && active < concurrent) {
                doInnerSub(buffer.shift());
            }
        };
        source.subscribe(new OperatorSubscriber(subscriber, function (value) { return (active < concurrent ? doInnerSub(value) : buffer.push(value)); }, undefined, function () {
            isComplete = true;
            checkComplete();
        }));
        return function () {
            buffer = null;
        };
    });
}
//# sourceMappingURL=mergeScan.js.map