import { __spreadArrays } from "tslib";
import { operate } from '../util/lift';
import { isScheduler } from '../util/isScheduler';
import { argsOrArgArray } from '../util/argsOrArgArray';
import { fromArray } from '../observable/fromArray';
import { mergeAll } from './mergeAll';
export function merge() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var concurrent = Infinity;
    var scheduler = undefined;
    if (isScheduler(args[args.length - 1])) {
        scheduler = args.pop();
    }
    if (typeof args[args.length - 1] === 'number') {
        concurrent = args.pop();
    }
    args = argsOrArgArray(args);
    return operate(function (source, subscriber) {
        mergeAll(concurrent)(fromArray(__spreadArrays([source], args), scheduler)).subscribe(subscriber);
    });
}
export function mergeWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return merge.apply(void 0, otherSources);
}
//# sourceMappingURL=mergeWith.js.map