import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function scan(accumulator, seed) {
    var hasSeed = arguments.length >= 2;
    return operate(function (source, subscriber) {
        var hasState = hasSeed;
        var state = seed;
        var index = 0;
        source.subscribe(new OperatorSubscriber(subscriber, function (value) {
            var i = index++;
            subscriber.next((state = hasState
                ?
                    accumulator(state, value, i)
                :
                    ((hasState = true), value)));
        }));
    });
}
//# sourceMappingURL=scan.js.map