import { EMPTY } from '../observable/empty';
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function takeLast(count) {
    return count <= 0
        ? function () { return EMPTY; }
        : operate(function (source, subscriber) {
            var buffer = [];
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                buffer.push(value);
                count < buffer.length && buffer.shift();
            }, undefined, function () {
                while (buffer.length) {
                    subscriber.next(buffer.shift());
                }
                subscriber.complete();
                buffer = null;
            }));
        });
}
//# sourceMappingURL=takeLast.js.map