import { asyncScheduler } from '../scheduler/async';
import { isValidDate } from '../util/isDate';
import { operate } from '../util/lift';
import { from } from '../observable/from';
import { createErrorClass } from '../util/createErrorClass';
import { OperatorSubscriber } from './OperatorSubscriber';
export var TimeoutError = createErrorClass(function (_super) {
    return function TimeoutError(info) {
        if (info === void 0) { info = null; }
        _super(this);
        this.message = 'Timeout has occurred';
        this.name = 'TimeoutError';
        this.info = info;
    };
});
export function timeout(config, schedulerArg) {
    var _a = (isValidDate(config)
        ? { first: config }
        : typeof config === 'number'
            ? { each: config }
            : config), first = _a.first, each = _a.each, _b = _a.with, _with = _b === void 0 ? timeoutErrorFactory : _b, _c = _a.scheduler, scheduler = _c === void 0 ? schedulerArg !== null && schedulerArg !== void 0 ? schedulerArg : asyncScheduler : _c, _d = _a.meta, meta = _d === void 0 ? null : _d;
    if (first == null && each == null) {
        throw new TypeError('No timeout provided.');
    }
    return operate(function (source, subscriber) {
        var originalSourceSubscription;
        var timerSubscription;
        var lastValue = null;
        var seen = 0;
        var startTimer = function (delay) {
            subscriber.add((timerSubscription = scheduler.schedule(function () {
                var withObservable;
                try {
                    withObservable = from(_with({
                        meta: meta,
                        lastValue: lastValue,
                        seen: seen,
                    }));
                }
                catch (err) {
                    subscriber.error(err);
                    return;
                }
                originalSourceSubscription.unsubscribe();
                withObservable.subscribe(subscriber);
            }, delay)));
        };
        subscriber.add((originalSourceSubscription = source.subscribe(new OperatorSubscriber(subscriber, function (value) {
            timerSubscription.unsubscribe();
            seen++;
            subscriber.next((lastValue = value));
            each > 0 && startTimer(each);
        }, undefined, undefined, function () {
            lastValue = null;
        }))));
        startTimer(first != null ? (typeof first === 'number' ? first : +first - scheduler.now()) : each);
    });
}
function timeoutErrorFactory(info) {
    throw new TimeoutError(info);
}
//# sourceMappingURL=timeout.js.map