import { __spreadArrays } from "tslib";
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { from } from '../observable/from';
import { identity } from '../util/identity';
import { noop } from '../util/noop';
export function withLatestFrom() {
    var inputs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        inputs[_i] = arguments[_i];
    }
    var project;
    if (typeof inputs[inputs.length - 1] === 'function') {
        project = inputs.pop();
    }
    return operate(function (source, subscriber) {
        var len = inputs.length;
        var otherValues = new Array(len);
        var hasValue = inputs.map(function () { return false; });
        var ready = false;
        source.subscribe(new OperatorSubscriber(subscriber, function (value) {
            if (ready) {
                var values = __spreadArrays([value], otherValues);
                subscriber.next(project ? project.apply(void 0, values) : values);
            }
        }));
        var _loop_1 = function (i) {
            var input = inputs[i];
            var otherSource = void 0;
            try {
                otherSource = from(input);
            }
            catch (err) {
                subscriber.error(err);
                return { value: void 0 };
            }
            otherSource.subscribe(new OperatorSubscriber(subscriber, function (value) {
                otherValues[i] = value;
                if (!ready && !hasValue[i]) {
                    hasValue[i] = true;
                    (ready = hasValue.every(identity)) && (hasValue = null);
                }
            }, undefined, noop));
        };
        for (var i = 0; i < len; i++) {
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
    });
}
//# sourceMappingURL=withLatestFrom.js.map