import { __spreadArrays } from "tslib";
import { operate } from '../util/lift';
import { zip } from '../observable/zip';
export function zipAll(project) {
    return operate(function (source, subscriber) {
        var sources = [];
        subscriber.add(source.subscribe({
            next: function (source) { return sources.push(source); },
            error: function (err) { return subscriber.error(err); },
            complete: function () {
                if (sources.length > 0) {
                    var args = project ? __spreadArrays(sources, [project]) : sources;
                    subscriber.add(zip.apply(void 0, args).subscribe(subscriber));
                }
                else {
                    subscriber.complete();
                }
            },
        }));
    });
}
//# sourceMappingURL=zipAll.js.map