/** @prettier */
import { Observable } from '../Observable';
import { ObservableInput, ObservedValueUnionFromArray } from '../types';
import { Subscriber } from '../Subscriber';
export declare function race<A extends ObservableInput<any>[]>(observables: A): Observable<ObservedValueUnionFromArray<A>>;
export declare function race<A extends ObservableInput<any>[]>(...observables: A): Observable<ObservedValueUnionFromArray<A>>;
/**
 * An observable initializer function for both the static version and the
 * operator version of race.
 * @param sources The sources to race
 */
export declare function raceInit<T>(sources: ObservableInput<T>[]): (subscriber: Subscriber<T>) => void;
//# sourceMappingURL=race.d.ts.map