"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.share = void 0;
var Subject_1 = require("../Subject");
var Subscriber_1 = require("../Subscriber");
var from_1 = require("../observable/from");
var lift_1 = require("../util/lift");
function share(options) {
    options = options || {};
    var _a = options.connector, connector = _a === void 0 ? function () { return new Subject_1.Subject(); } : _a, _b = options.resetOnComplete, resetOnComplete = _b === void 0 ? true : _b, _c = options.resetOnError, resetOnError = _c === void 0 ? true : _c, _d = options.resetOnRefCountZero, resetOnRefCountZero = _d === void 0 ? true : _d;
    var connection = null;
    var subject = null;
    var refCount = 0;
    var hasCompleted = false;
    var hasErrored = false;
    var reset = function () {
        connection = subject = null;
        hasCompleted = hasErrored = false;
    };
    return lift_1.operate(function (source, subscriber) {
        refCount++;
        subject = subject !== null && subject !== void 0 ? subject : connector();
        subject.subscribe(subscriber);
        if (!connection) {
            connection = new Subscriber_1.SafeSubscriber({
                next: function (value) { return subject.next(value); },
                error: function (err) {
                    hasErrored = true;
                    var dest = subject;
                    if (resetOnError) {
                        reset();
                    }
                    dest.error(err);
                },
                complete: function () {
                    hasCompleted = true;
                    var dest = subject;
                    if (resetOnComplete) {
                        reset();
                    }
                    dest.complete();
                },
            });
            from_1.from(source).subscribe(connection);
        }
        return function () {
            refCount--;
            if (resetOnRefCountZero && !refCount && !hasErrored && !hasCompleted) {
                var conn = connection;
                reset();
                conn === null || conn === void 0 ? void 0 : conn.unsubscribe();
            }
        };
    });
}
exports.share = share;
//# sourceMappingURL=share.js.map