import { Subject } from '../Subject';
import { SafeSubscriber } from '../Subscriber';
import { from } from '../observable/from';
import { operate } from '../util/lift';
export function share(options) {
    options = options || {};
    const { connector = () => new Subject(), resetOnComplete = true, resetOnError = true, resetOnRefCountZero = true } = options;
    let connection = null;
    let subject = null;
    let refCount = 0;
    let hasCompleted = false;
    let hasErrored = false;
    const reset = () => {
        connection = subject = null;
        hasCompleted = hasErrored = false;
    };
    return operate((source, subscriber) => {
        refCount++;
        subject = subject !== null && subject !== void 0 ? subject : connector();
        subject.subscribe(subscriber);
        if (!connection) {
            connection = new SafeSubscriber({
                next: (value) => subject.next(value),
                error: (err) => {
                    hasErrored = true;
                    const dest = subject;
                    if (resetOnError) {
                        reset();
                    }
                    dest.error(err);
                },
                complete: () => {
                    hasCompleted = true;
                    const dest = subject;
                    if (resetOnComplete) {
                        reset();
                    }
                    dest.complete();
                },
            });
            from(source).subscribe(connection);
        }
        return () => {
            refCount--;
            if (resetOnRefCountZero && !refCount && !hasErrored && !hasCompleted) {
                const conn = connection;
                reset();
                conn === null || conn === void 0 ? void 0 : conn.unsubscribe();
            }
        };
    });
}
//# sourceMappingURL=share.js.map