import { Subject } from '../Subject';
import { SafeSubscriber } from '../Subscriber';
import { from } from '../observable/from';
import { operate } from '../util/lift';
export function share(options) {
    options = options || {};
    var _a = options.connector, connector = _a === void 0 ? function () { return new Subject(); } : _a, _b = options.resetOnComplete, resetOnComplete = _b === void 0 ? true : _b, _c = options.resetOnError, resetOnError = _c === void 0 ? true : _c, _d = options.resetOnRefCountZero, resetOnRefCountZero = _d === void 0 ? true : _d;
    var connection = null;
    var subject = null;
    var refCount = 0;
    var hasCompleted = false;
    var hasErrored = false;
    var reset = function () {
        connection = subject = null;
        hasCompleted = hasErrored = false;
    };
    return operate(function (source, subscriber) {
        refCount++;
        subject = subject !== null && subject !== void 0 ? subject : connector();
        subject.subscribe(subscriber);
        if (!connection) {
            connection = new SafeSubscriber({
                next: function (value) { return subject.next(value); },
                error: function (err) {
                    hasErrored = true;
                    var dest = subject;
                    if (resetOnError) {
                        reset();
                    }
                    dest.error(err);
                },
                complete: function () {
                    hasCompleted = true;
                    var dest = subject;
                    if (resetOnComplete) {
                        reset();
                    }
                    dest.complete();
                },
            });
            from(source).subscribe(connection);
        }
        return function () {
            refCount--;
            if (resetOnRefCountZero && !refCount && !hasErrored && !hasCompleted) {
                var conn = connection;
                reset();
                conn === null || conn === void 0 ? void 0 : conn.unsubscribe();
            }
        };
    });
}
//# sourceMappingURL=share.js.map