"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.materialize = void 0;
var NotificationFactories_1 = require("../NotificationFactories");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function materialize() {
    return lift_1.operate(function (source, subscriber) {
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            subscriber.next(NotificationFactories_1.nextNotification(value));
        }, function () {
            subscriber.next(NotificationFactories_1.COMPLETE_NOTIFICATION);
            subscriber.complete();
        }, function (error) {
            subscriber.next(NotificationFactories_1.errorNotification(error));
            subscriber.complete();
        }));
    });
}
exports.materialize = materialize;
//# sourceMappingURL=materialize.js.map