import { COMPLETE_NOTIFICATION, errorNotification, nextNotification } from '../NotificationFactories';
import { operate } from '../util/lift';
import { createOperatorSubscriber } from './OperatorSubscriber';
export function materialize() {
    return operate((source, subscriber) => {
        source.subscribe(createOperatorSubscriber(subscriber, (value) => {
            subscriber.next(nextNotification(value));
        }, () => {
            subscriber.next(COMPLETE_NOTIFICATION);
            subscriber.complete();
        }, (error) => {
            subscriber.next(errorNotification(error));
            subscriber.complete();
        }));
    });
}
//# sourceMappingURL=materialize.js.map