import { COMPLETE_NOTIFICATION, errorNotification, nextNotification } from '../NotificationFactories';
import { operate } from '../util/lift';
import { createOperatorSubscriber } from './OperatorSubscriber';
export function materialize() {
    return operate(function (source, subscriber) {
        source.subscribe(createOperatorSubscriber(subscriber, function (value) {
            subscriber.next(nextNotification(value));
        }, function () {
            subscriber.next(COMPLETE_NOTIFICATION);
            subscriber.complete();
        }, function (error) {
            subscriber.next(errorNotification(error));
            subscriber.complete();
        }));
    });
}
//# sourceMappingURL=materialize.js.map