import { OAuth2Provider } from '@salte-auth/salte-auth';
export declare class Cognito extends OAuth2Provider {
    constructor(config: Cognito.Config);
    readonly name: string;
    readonly login: string;
    readonly logout: string;
}
export interface Cognito {
    config: Cognito.Config;
}
export declare namespace Cognito {
    interface Config extends OAuth2Provider.Config {
        /**
         * The domain of your Cognito tenant.
         *
         * @example 'https://salte-os.auth.us-east-1.amazoncognito.com'
         */
        url: string;
        /**
         * The unique identifier of the target API you want to access.
         */
        audience?: string;
    }
}
