
/**
 * @salte-auth/cognito JavaScript Library v1.0.0-rc.1
 *
 * @license MIT (https://github.com/salte-auth/cognito/blob/master/LICENSE)
 *
 * Made with ♥ by Nick Woodward <nick@salte.io>, Dave Woodward <dave@salte.io>
 */

(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@salte-auth/salte-auth')) :
  typeof define === 'function' && define.amd ? define(['exports', '@salte-auth/salte-auth'], factory) :
  (global = global || self, factory((global.salte = global.salte || {}, global.salte.auth = global.salte.auth || {}, global.salte.auth.cognito = {}), global.salte.auth));
}(this, function (exports, salteAuth) { 'use strict';

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  var classCallCheck = _classCallCheck;

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  var createClass = _createClass;

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var _typeof_1 = createCommonjsModule(function (module) {
  function _typeof2(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof2 = function _typeof2(obj) { return typeof obj; }; } else { _typeof2 = function _typeof2(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof2(obj); }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      module.exports = _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      module.exports = _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  module.exports = _typeof;
  });

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  var assertThisInitialized = _assertThisInitialized;

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof_1(call) === "object" || typeof call === "function")) {
      return call;
    }

    return assertThisInitialized(self);
  }

  var possibleConstructorReturn = _possibleConstructorReturn;

  var getPrototypeOf = createCommonjsModule(function (module) {
  function _getPrototypeOf(o) {
    module.exports = _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  module.exports = _getPrototypeOf;
  });

  var setPrototypeOf = createCommonjsModule(function (module) {
  function _setPrototypeOf(o, p) {
    module.exports = _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  module.exports = _setPrototypeOf;
  });

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) setPrototypeOf(subClass, superClass);
  }

  var inherits = _inherits;

  var Cognito =
  /*#__PURE__*/
  function (_OAuth2Provider) {
    inherits(Cognito, _OAuth2Provider);

    function Cognito(config) {
      classCallCheck(this, Cognito);

      return possibleConstructorReturn(this, getPrototypeOf(Cognito).call(this, config));
    }

    createClass(Cognito, [{
      key: "name",
      get: function get() {
        return 'cognito';
      }
    }, {
      key: "login",
      get: function get() {
        return this.url("".concat(this.config.url, "/oauth2/authorize"));
      }
    }, {
      key: "logout",
      get: function get() {
        return this.url("".concat(this.config.url, "/logout"), {
          logout_uri: this.redirectUrl('logout'),
          client_id: this.config.clientID
        });
      }
    }]);

    return Cognito;
  }(salteAuth.OAuth2Provider);

  exports.Cognito = Cognito;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=cognito.js.map
