
/**
 * @salte-auth/cognito JavaScript Library v1.0.0-rc.1
 *
 * @license MIT (https://github.com/salte-auth/cognito/blob/master/LICENSE)
 *
 * Made with ♥ by Nick Woodward <nick@salte.io>, Dave Woodward <dave@salte.io>
 */

import { OAuth2Provider } from '@salte-auth/salte-auth';

class Cognito extends OAuth2Provider {
  constructor(config) {
    super(config);
  }

  get name() {
    return 'cognito';
  }

  get login() {
    return this.url("".concat(this.config.url, "/oauth2/authorize"));
  }

  get logout() {
    return this.url("".concat(this.config.url, "/logout"), {
      logout_uri: this.redirectUrl('logout'),
      client_id: this.config.clientID
    });
  }

}

export { Cognito };
//# sourceMappingURL=cognito.mjs.map
