import { Required } from './required';
import { StorageHelpers } from '../../utils';
export declare class Storage extends Required {
    storage: (StorageHelpers.CookieStorage | StorageHelpers.LocalStorage | StorageHelpers.SessionStorage);
    constructor(config?: Storage.Config);
    protected readonly key: string;
}
export interface Storage {
    config: Storage.Config;
}
export declare namespace Storage {
    interface Config extends Required.Config {
        /**
         * The storage api to keep authenticate information stored in.
         *
         * Due to a known issue in Edge we recommend utilizing the 'cookie' storage type.
         * https://github.com/AzureAD/azure-activedirectory-library-for-js/wiki/Known-issues-on-Edge
         *
         * @default 'cookie'
         */
        storage?: ('local' | 'session' | 'cookie');
    }
}
