import { Storage } from './core/storage';
import { Logger } from '../utils';
export declare class Handler extends Storage {
    protected logger: Logger;
    constructor(config?: Handler.Config);
    /**
     * The unique name of the handler
     */
    readonly $name: string;
    protected readonly key: string;
    /**
     * Navigates to the url provided.
     * @param url the url to navigate to
     */
    protected navigate(url: string): void;
}
export interface Handler {
    config: Handler.Config;
    /**
     * The unique name of the handler
     */
    name: string;
    /**
     * Determines whether the handler supports automatic login.
     */
    auto: boolean;
    open(options: Handler.OpenOptions): Promise<object>;
    connected?(options: Handler.ConnectedOptions): object | void;
}
export declare namespace Handler {
    interface Config extends Storage.Config {
        /**
         * Overrides the default name of the handler.
         */
        name?: string;
        /**
         * Dictates that this is the default handler.
         */
        default?: boolean;
        /**
         * Determines how page navigations are interpreted by this handler.
         *
         * * **reload:** Reloads the whole page when `navigate` is invoked.
         * * **history:** Utilizes the history api to prevent page reloads when possible.
         *
         * @default 'reload'
         */
        navigate?: ('reload' | 'history');
        /**
         * Determines the level of verbosity of the logs.
         *
         * @default 'warn'
         */
        level?: ('error' | 'warn' | 'info' | 'trace');
    }
    interface ConnectedOptions {
        action?: string;
    }
    interface OpenOptions {
        url: string;
        redirectUrl: string;
    }
}
