import { AccessToken, Interceptors } from '../utils';
import { Provider } from './core/provider';
export declare class OAuth2Provider extends Provider {
    accessToken?: AccessToken;
    constructor(config?: OAuth2Provider.Config);
    connected(): void;
    secure(request: Interceptors.XHR.ExtendedXMLHttpRequest | Request): Promise<string | boolean>;
    $validate(options: OAuth2Provider.Validation): void;
    validate(options: OAuth2Provider.Validation): void;
    readonly code: string;
    $login(options?: OAuth2Provider.OverrideOptions): string;
    sync(): void;
}
export interface OAuth2Provider {
    config: OAuth2Provider.Config;
    on(name: 'login', listener: (error?: Error, accessToken?: AccessToken) => void): void;
    on(name: 'login', listener: (error?: Error, code?: string) => void): void;
    on(name: 'logout', listener: (error?: Error) => void): void;
}
export declare namespace OAuth2Provider {
    interface Config extends Provider.Config {
        /**
         * Determines whether a authorization code (server) or access token (client) should be returned.
         * @type {('code'|'token')}
         */
        responseType?: string;
        /**
         * A list of space-delimited claims used to determine what user information is provided and what access is given.
         */
        scope?: string;
        /**
         * The client id of your identity provider
         */
        clientID: string;
        validation?: boolean | ValidationOptions;
    }
    interface OverrideOptions {
        /**
         * Determines whether a authorization code (server) or access token (client) should be returned.
         * @type {('code'|'token')}
         */
        responseType?: string;
    }
    interface ValidationOptions extends Provider.ValidationOptions {
        /**
         * Disables cross-site forgery validation via "state".
         */
        state: boolean;
    }
    interface Validation {
        /**
         * An error code sent from the Provider
         */
        error: ('unauthorized_client' | 'access_denied' | 'unsupported_response_type' | 'invalid_scope' | 'server_error' | 'temporarily_unavailable');
        /**
         * Human-readable message sent back by the Provider.
         */
        error_description?: string;
        /**
         * A URI to a human-readable web page with information about the error.
         */
        error_uri?: string;
        /**
         * A value sent back by the server to the client.
         *
         * Used to prevent cross-site request forgery.
         */
        state: string;
        /**
         * The authorization code generated by the Provider.
         *
         * Generally used by a backend server to generate an access token.
         */
        code: string;
        /**
         * The access token issued by the Provider.
         */
        access_token: string;
        /**
         * The type of the token issued.
         */
        token_type: ('bearer' | 'mac');
        /**
         * The lifetime (in seconds) of the access_token.
         *
         * For example, the value "3600" denotes that the access token will
         * expire in one hour from the time the response was generated.
         */
        expires_in: string;
    }
}
