import { SalteAuthMixedIn, Constructor } from './mixins/auth';
import { Shared } from './base/core/shared';
import * as Generic from './generic';
import * as Utils from './utils';
import { IDToken, Logger } from './utils';
import { Provider } from './base/core/provider';
import { Handler } from './base/handler';
export declare class SalteAuth extends Shared {
    logger: Logger;
    mixin: (base: Constructor) => SalteAuthMixedIn;
    constructor(config: SalteAuth.Config);
    /**
     * Login to the specified provider.
     *
     * @param options the authentication options
     */
    login(options: SalteAuth.AuthOptions): Promise<void>;
    /**
     * Login to the specified provider.
     *
     * @param provider the provider to login with
     */
    login(provider: string): Promise<void>;
    /**
     * Logout of the specified provider.
     *
     * @param options the authentication options
     */
    logout(options: SalteAuth.AuthOptions): Promise<void>;
    /**
     * Logout of the specified provider.
     *
     * @param provider the provider to logout of
     */
    logout(provider: string): Promise<void>;
    /**
     * Returns a provider that matches the given name.
     * @param name the name of the provider
     * @returns the provider with the given name.
     */
    provider(name?: string): Provider;
    /**
     * Returns a handler that matches the given name.
     * @param name the name of the handler
     * @returns the handler with the given name, if no name is specified then the default handler.
     */
    handler(name?: string): Handler;
}
export interface SalteAuth {
    config: SalteAuth.Config;
    on(name: 'login', listener: (error?: Error, data?: SalteAuth.EventWrapper) => void): void;
    on(name: 'logout', listener: (error?: Error, data?: SalteAuth.EventWrapper) => void): void;
}
export declare namespace SalteAuth {
    interface Config extends Shared.Config {
        providers: Provider[];
        handlers: Handler[];
        /**
         * Determines the level of verbosity of the logs.
         *
         * @default 'warn'
         */
        level?: ('error' | 'warn' | 'info' | 'trace');
    }
    interface EventWrapper {
        provider: string;
        data?: IDToken.UserInfo | string;
    }
    interface AuthOptions {
        provider: string;
        handler?: string;
    }
}
export { SalteAuthError } from './base/core/salte-auth-error';
export { OAuth2Provider } from './base/provider-oauth2';
export { OpenIDProvider } from './base/provider-openid';
export { Handler, Utils, Generic };
