export declare class Common {
    static includes(source: any[] | string, value: any): boolean;
    static forEach<T>(source: T[], cb: (value: T, key: number | string) => void): void;
    static forEach<T extends object>(source: T, cb: (item: any, key: number | string) => void): void;
    static find<T>(source: T[], cb: (value: T, key: number | string) => boolean): T;
    static find<T extends object>(source: T, cb: (item: any, key: number | string) => boolean): any;
    static assign(target: any, ...sources: any[]): any;
    static defaults(target: any, ...sources: any[]): any;
    static isObject(value: any): boolean;
    static iframe({ url, redirectUrl, visible }: Common.IFrameOptions): Promise<any>;
    static debounce(identifier: string, callback: () => void, timeout?: number): void;
}
export declare namespace Common {
    interface IFrameOptions {
        url: string;
        redirectUrl: string;
        visible?: boolean;
    }
}
